<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddTimeSlotToAvailabilityTable extends Migration
{
    public function up()
    {
        Schema::table('availability', function (Blueprint $table) {
            $table->enum('time_slot', ['Morning', 'Afternoon', 'Evening'])->after('day_of_week')->nullable(false);
        });
    }

    public function down()
    {
        Schema::table('availability', function (Blueprint $table) {
            $table->dropColumn('time_slot');
        });
    }
}
